package com.example.jcetest;

import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.example.chapter3.Utils;

public class MainActivity extends Activity {

	private TextView inputTextView;
	private TextView cipherTextView;
	private TextView plainTextView;
	private TextView testButton;
	private TextView testTitle;
	private int condition;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		inputTextView = (TextView) findViewById(R.id.input_text);
		cipherTextView = (TextView) findViewById(R.id.cipher_text);
		plainTextView = (TextView) findViewById(R.id.plain_text);
		testButton = (TextView) findViewById(R.id.test_button);
		testTitle = (TextView) findViewById(R.id.test_title);
		testTitle.setText(getApplicationContext().getString(R.string.test1));
		testButton.setText("Next "+getApplicationContext().getString(R.string.test2));
		condition = 0;
	}

	@Override
	protected void onResume() {
		super.onResume();
		try {
			switch( condition ){
				case 0:
					testTitle.setText(getApplicationContext().getString(R.string.test1));
					testButton.setText("Next "+getApplicationContext().getString(R.string.test2));
					PrecedenceTest();	
					break;
				case 1:
					testTitle.setText(getApplicationContext().getString(R.string.test2));
					testButton.setText("Next "+getApplicationContext().getString(R.string.test3));
					InlineIvCBCExample();	
					break;
				case 2:
					testTitle.setText(getApplicationContext().getString(R.string.test3));
					testButton.setText("Next "+getApplicationContext().getString(R.string.test1));
					Tamperedwithhmacexam();	
					break;
			}
			testButton.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					if( condition < 2)
						condition++;
					else
						condition = 0;
					onResume();
				}
			});
		} catch (Exception e) {

		}
	}

	public void PrecedenceTest() throws Exception {
		Cipher cipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
		inputTextView.setText(cipher.getProvider().toString());
		cipher = Cipher.getInstance("Blowfish/ECB/NoPadding", "BC");
		plainTextView.setText(cipher.getProvider().toString());
		cipherTextView.setText("");
	}
	
	public void InlineIvCBCExample() throws Exception {
		byte[] input = new byte[] {
				0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
				0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
				0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07 };
		byte[] keyBytes = new byte[] {
				0x01, 0x23, 0x45, 0x67,
				(byte) 0x89, (byte) 0xab, (byte) 0xcd, (byte) 0xef };
		byte[] ivBytes = new byte[] {
				0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00 };
		SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
		IvParameterSpec ivSpec = new IvParameterSpec(new byte[8]);
		Cipher cipher = Cipher.getInstance("DES/CBC/PKCS7Padding", "BC");
		inputTextView.setText("input : "+ Utils.toHex(input));
		
		// encryption pass
		cipher.init(Cipher.ENCRYPT_MODE, key, ivSpec);
		
		byte[] cipherText = new byte[cipher.getOutputSize(ivBytes.length+input.length)];
		
		int ctLength = cipher.update(ivBytes, 0, ivBytes.length, cipherText, 0);
		
		ctLength += cipher.update(input, 0, input.length, cipherText, ctLength);
		
		ctLength += cipher.doFinal(cipherText, ctLength);
		
		cipherTextView.setText("cipher : "+Utils.toHex(cipherText, ctLength)+ " bytes: "+ctLength);
		
		// decryption pass
		cipher.init(Cipher.DECRYPT_MODE, key, ivSpec);
		
		byte[] buf = new byte[cipher.getOutputSize(ctLength)];
		
		int bufLength = cipher.update(cipherText, 0, ctLength, buf, 0);
		
		bufLength += cipher.doFinal(buf, bufLength);
		
		// remove the iv from the start of the message
		
		byte[] plainText = new byte[bufLength - ivBytes.length];
		
		System.arraycopy(buf, ivBytes.length, plainText, 0, plainText.length);
		
		plainTextView.setText("plain : "+ Utils.toHex(plainText, plainText.length)+" bytes: "+plainText.length);
	}
	
	public void Tamperedwithhmacexam() throws Exception {
		SecureRandom random = new SecureRandom();
		IvParameterSpec ivSpec = Utils.createCtrIvForAES(1, random);
		Key key = Utils.createKeyForAES(256, random);
		Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
		String input = "Transfer 0000100 to AC 1234-5678";
		Mac hMac = Mac.getInstance("HmacSHA1", "BC");
		Key hMacKey = new SecretKeySpec(key.getEncoded(), "HmacSHA1");
		inputTextView.setText("input : "+ input);
		
		// encryption step
		cipher.init(Cipher.ENCRYPT_MODE, key, ivSpec);
		byte[] cipherText = new byte[cipher.getOutputSize(input.length()+hMac.getMacLength())];
		int ctLength = cipher.update(Utils.toByteArray(input), 0, input.length(), cipherText, 0);
		hMac.init(hMacKey);
		hMac.update(Utils.toByteArray(input));
		ctLength += cipher.doFinal(hMac.doFinal(), 0, hMac.getMacLength(), cipherText, ctLength);
		
		// tampering step
		cipherText[9] ^= '0' ^ '9';
		
		// replace digest
		// ?
		
		// decryption pass
		cipher.init(Cipher.DECRYPT_MODE, key, ivSpec);
		byte[] plainText = cipher.doFinal(cipherText, 0, ctLength);
		int messageLength = plainText.length - hMac.getMacLength();
		hMac.init(hMacKey);
		hMac.update(plainText,0,messageLength);
		byte[] messageHash = new byte[hMac.getMacLength()];
		System.arraycopy(plainText, messageLength, messageHash, 0, messageHash.length);
		plainTextView.setText("plain : "+Utils.toString(plainText, messageLength)
				+" verfied : "+ MessageDigest.isEqual(hMac.doFinal(), messageHash));
		cipherTextView.setText("");
	}
}
