pragma solidity ^0.4.24;

contract SimpleCoin{
    //data
    address public minter;
    mapping(address=>uint) public balances;

    //events
    event sent(address from, address to, uint amount);
    event minted( address indexed receiver, uint amount);

    constructor() public {
        minter = msg.sender;
    }

    modifier onlyMinter { 
        require(msg.sender == minter);
        _;
    }   

    function mint(uint amount) public onlyMinter {
        balances[minter] += amount;
        emit minted( minter, amount ); 
    }

    function send(address from, address to, uint amount) public onlyMinter {
        require(balances[from] >= amount);
        balances[from] -= amount;
        balances[to] += amount;
        emit sent(from, to, amount);
    }

    function balanceOf(address eoa) public view returns (uint) {
        return balances[eoa];
    }

    function mintTo(address rec, uint amnt) public onlyMinter {
        balances[rec] += amnt;
        emit minted( rec, amnt ); 
    }

}