import { Component } from '@angular/core';
import { NavController } from 'ionic-angular';
import {Http} from '@angular/http';
import {MovieService} from '../../providers/movie-service/movie-service';

@Component({
  templateUrl: 'build/pages/home/home.html',
  providers: [MovieService]
})
export class HomePage {
  items: any;
  items_original: any;
  keyword: string;

  constructor(public navCtrl: NavController, public http: Http, public movies: MovieService) {
    this.refreshMovieList();
    //this.keyword='';
  }

  keyPressed(e) {
    this.items = this.items_original.filter( item => item.show_title.toLowerCase().includes(this.keyword.toLowerCase()));
  }

  enterPressed(e) {
    console.log('enter pressed');
  }

  refreshMovieList() {
      this.movies.getMovies().subscribe(
        response => {
          this.items = this.items_original = response.json();
              console.log(this.items_original);
            }
      );


  }

}
