import { Component } from '@angular/core';
import {Geolocation} from 'ionic-native';

/*
  Generated class for the Map component.

  See https://angular.io/docs/ts/latest/api/core/index/ComponentMetadata-class.html
  for more info on Angular 2 Components.
*/
@Component({
  selector: 'map',
  templateUrl: 'map.html'
})
export class Map {
  map
  marker
  infowin
  ngOnInit() {
    Geolocation.getCurrentPosition().then (	(resp) => {			console.log(resp.coords.latitude);			console.log(resp.coords.longitude);
      this.map = new google.maps.Map(document.getElementById( 'map'),
                                    { zoom:15, center: {lat:resp.coords.latitude, lng: resp.coords.longitude},
                                      mapTypeId: google.maps.MapTypeId.ROADMAP } );
        this.marker= new google.maps.Marker( {
          map: this.map,
          position: this.map.getCenter(),
          animation: google.maps.Animation.DROP
        });
         this.infowin = new google.maps.InfoWindow( {
          content: "<h4> I am here"
        });
        //infowin.open(this.map, marker);
        google.maps.event.addListener(this.marker, 'click', () => {
          this.infowin.open(this.map, this.marker);
      });

    });

  }

  showWeatherMap(weather) {
    let loc = {lat: weather.coord.lat, lng: weather.coord.lon};
    this.map.setCenter(loc);
    this.marker.setPosition(loc);

    let content = `
    <ion-grid>
      <ion-row>
        <ion-col>
          <ion-thumbnail item-left>
            <img src = \"http://openweathermap.org/img/w/`
              +weather.weather[0].icon+`.png\" height=50>
          </ion-thumbnail>
          </ion-col>
          <ion-col>
            <p>`+weather.main.temp+`</p>
          </ion-col>
      </ion-row>
      <ion-row>
          <p>`+weather.name+`</p>
      </ion-row>
      <ion-row>
          <p> Low: `+weather.main.temp_min+` High: `+weather.main.temp_max+`</p>
      </ion-row>
    </ion-grid>`;
    this.infowin.setContent( content );
  }

}
