import { Component } from '@angular/core';
import {Geolocation} from 'ionic-native';

/*
  Generated class for the Map component.

  See https://angular.io/docs/ts/latest/api/core/index/ComponentMetadata-class.html
  for more info on Angular 2 Components.
*/
@Component({
  selector: 'map',
  templateUrl: 'map.html'
})
export class Map {
  map
  ngOnInit() {
    Geolocation.getCurrentPosition().then (	(resp) => {			console.log(resp.coords.latitude);			console.log(resp.coords.longitude);
      this.map = new google.maps.Map(document.getElementById( 'map'),
                                    { zoom:15, center: {lat:resp.coords.latitude, lng: resp.coords.longitude},
                                      mapTypeId: google.maps.MapTypeId.ROADMAP } );
        let marker= new google.maps.Marker( {
          map: this.map,
          position: this.map.getCenter(),
          animation: google.maps.Animation.DROP
        });
        let infowin = new google.maps.InfoWindow( {
          content: "<h4> I am here"
        });
        //infowin.open(this.map, marker);
        google.maps.event.addListener(marker, 'click', () => {
          infowin.open(this.map, marker);
      });

    });

  }

}
