import { Component } from '@angular/core';

import { NavController, ModalController } from 'ionic-angular';

import {Addweather} from '../addweather/addweather';
import {Openweather} from '../../providers/openweather';
import {Observable} from 'rxjs/Observable';
import 'rxjs/add/operator/map';

@Component({
  selector: 'page-home',
  templateUrl: 'home.html'
})
export class HomePage {
  weatherList = [];
  constructor(public navCtrl: NavController, public modalCtrl : ModalController, public weather : Openweather) {

  }
  onClick() {
     let m = this.modalCtrl.create(Addweather);
     m.onDismiss( (data) => {
       this.getWeather(data.city, data.country);
     })
     m.present();
  }

  getWeather( city: string, country:string ) {
    this.weather.getWeatherByCity(city, country )
    .map( data => data.json() )
    .subscribe(
      data=> {
        this.weatherList.push(data);
      });
    }

  }
