pragma solidity ^0.4.24;

contract BallotV4{

    // data
        struct Candidate {
                bytes32 name;
                uint voteCount;  }
        struct Voter {
                bool registered;
                bool voted;
                uint votedFor; }

        Candidate[] public candidates;
        mapping( address => Voter ) public voters;

        address public chairman;
        bytes32 public winnerName;
        enum Stage { REGISTRATION, VOTING, COUNTING, ANNOUNCED }

        uint public startTime;
        uint constant deadlineREG = 30; //7 days;
    uint constant deadlineVOT = 60; //8 days;

        // modifiers
        modifier onlyChairman { require( msg.sender == chairman, "OnlyChairman" ); _; }
        modifier onlyStage(Stage st) {
            require( now >= startTime, "Opps, something's wrong with startTime" );

            if( st == Stage.REGISTRATION )
                require( now < startTime + deadlineREG, "Not in REGISTRATION stage");
            else if( st == Stage.VOTING )
                require( startTime + deadlineREG < now && now <= startTime + deadlineVOT, "Not in VOTING stage" );
        else if( st == Stage.COUNTING )
            require( startTime + deadlineVOT < now && winnerName == "" );
        else // Stage.ANNOUNCED
            require( startTime + deadlineVOT < now && winnerName != "" );

           _;
        }

        function currentTime() public view returns (uint) {
            return (now-startTime);
        }

        // methods
        // ["obama", "trump", "clinton"] =
        //      [ "0x6f62616d61", "0x7472756d70", "0x636c696e746f6e" ]
        constructor( bytes32[] candNames ) public {
                chairman = msg.sender;
                for( uint i = 0; i < candNames.length; i++) {
                        candidates.push( Candidate( { name: candNames[i], voteCount: 0 }) );
                }

                startTime = now;
                registerVoter( chairman );
        }

        function restart() public onlyChairman {
                startTime = now;
        }

    function registerVoter( address voter ) public onlyChairman onlyStage(Stage.REGISTRATION) {
        voters[voter].registered = true;
        voters[voter].voted = false; // not necessary
        voters[voter].votedFor = 0; // not necessary
    }

    function vote( uint candNo ) public onlyStage(Stage.VOTING) {
        require( voters[msg.sender].registered );
        require( !voters[msg.sender].voted );
        require( candNo < candidates.length );
        voters[msg.sender].votedFor = candNo;
        candidates[ candNo ].voteCount++;
    }

    function winnerAnnounce() public onlyStage(Stage.COUNTING) {
        uint maxVoteCount = 0;
        for( uint i=0; i < candidates.length; i++ ) {
            if( candidates[i].voteCount > maxVoteCount ) {
                maxVoteCount = candidates[i].voteCount;
                winnerName = candidates[i].name;
            } else if( candidates[i].voteCount == maxVoteCount ) {
                winnerName = "TIE";
            }
        }
    }

    function winnerView() public view onlyStage(Stage.ANNOUNCED) returns (bytes32) {
        return bytes32(winnerName);
    }

        function destroy() public onlyChairman onlyStage(Stage.ANNOUNCED) {
            selfdestruct( chairman );
        }

}
