pragma solidity ^0.4.24;

contract BallotV3{

    // data
        struct Candidate {
                bytes32 name;
                uint voteCount;  }
        struct Voter {
                bool registered;
                bool voted;
                uint votedFor; }

        Candidate[] candidates;
        mapping( address => Voter ) voters;

        address chairman;
        bytes32 winnerName;
        //bool ballotOpen;
        enum Stage { REGISTRATION, VOTING, ANNOUNCED }
        Stage public stage;

        // modifiers
        modifier onlyChairman { require( msg.sender == chairman ); _; }
        modifier onlyStage(Stage st) { require(stage == st); _; }

        // methods
        // ["obama", "trump", "clinton"] =
        //      [ "0x6f62616d61", "0x7472756d70", "0x636c696e746f6e" ]
        constructor( bytes32[] candNames ) public {
                chairman = msg.sender;
                for( uint i = 0; i < candNames.length; i++) {
                        candidates.push( Candidate( { name: candNames[i], voteCount: 0 }) );
                }
                stage = Stage.REGISTRATION;
                registerVoter( chairman );
        }

    function registerVoter( address voter ) public onlyChairman onlyStage(Stage.REGISTRATION) {
        voters[voter].registered = true;
        voters[voter].voted = false; // not necessary
        voters[voter].votedFor = 0; // not necessary
    }

    function startVoting() public onlyStage(Stage.REGISTRATION) {
        stage = Stage.VOTING;
    }

    function vote( uint candNo ) public onlyStage(Stage.VOTING) {
        require( voters[msg.sender].registered );
        require( !voters[msg.sender].voted );
        require( candNo < candidates.length );
        voters[msg.sender].votedFor = candNo;
        candidates[ candNo ].voteCount++;
    }

    function endVoting() public onlyStage(Stage.VOTING) {
        winnerAnnounce();
        stage = Stage.ANNOUNCED;
    }

    function winnerAnnounce() private {
        require(winnerName=="");
        uint maxVoteCount = 0;
        for( uint i=0; i < candidates.length; i++ ) {
            if( candidates[i].voteCount > maxVoteCount ) {
                maxVoteCount = candidates[i].voteCount;
                winnerName = candidates[i].name;
                }
        }
    }

    function winnerView() public view onlyStage(Stage.ANNOUNCED) returns (bytes32) {
        require(winnerName != "");
        return winnerName;
    }

}
