pragma solidity ^0.4.24;

contract BallotV2{

    // data
        struct Candidate {
                bytes32 name;
                uint voteCount;  }
        struct Voter {
                bool registered;
                bool voted;
                uint votedFor; }

        Candidate[] candidates;
        mapping( address => Voter ) voters;

        address chairman;
        bytes32 winnerName;
        bool ballotOpen;

        // modifiers
        modifier onlyChairman { require( msg.sender == chairman ); _; }
        modifier onlyBallotOpenIs(bool open) {require(ballotOpen==open); _;}

        // methods
        constructor( bytes32[] candNames ) public {
                chairman = msg.sender;
                for( uint i = 0; i < candNames.length; i++) {
                        candidates.push( Candidate( { name: candNames[i], voteCount: 0 }) );
                }
                ballotOpen = false;
                registerVoter( chairman );
        }

    function registerVoter( address voter ) public onlyChairman onlyBallotOpenIs(false) {
        voters[voter].registered = true;
        voters[voter].voted = false; // not necessary
        voters[voter].votedFor = 0; // not necessary
    }

    function vote( uint candNo ) public onlyBallotOpenIs(true) {
        require( voters[msg.sender].registered );
        require( !voters[msg.sender].voted );
        require( candNo < candidates.length );
        voters[msg.sender].votedFor = candNo;
        candidates[ candNo ].voteCount++;
    }

    function winnerView() public view onlyBallotOpenIs(false) returns (bytes32) {
        require(winnerName != "");
        return winnerName;
    }

    function winnerAnnounce() public onlyBallotOpenIs(false) {
        require(winnerName=="");
        uint maxVoteCount = 0;
        for( uint i=0; i < candidates.length; i++ ) {
            if( candidates[i].voteCount > maxVoteCount ) {
                maxVoteCount = candidates[i].voteCount;
                winnerName = candidates[i].name;
                }
        }
    }

    function openBallot() public onlyChairman { ballotOpen=true; }
    function closeBallot() public onlyChairman { ballotOpen=false; }
}
