pragma solidity ^0.4.24;

contract BallotV1 {
        struct Candidate {
                bytes32 name;
                uint voteCount;  }
        struct Voter {
                bool registered;
                bool voted;
                uint votedFor; }
        address public chairman;

        mapping( address => Voter ) public voters;
        Candidate[] public candidates;
    bytes32 public winnerName;
    event winnerAnnounced( bytes32 winnerName );


        modifier onlyChairman { require( msg.sender == chairman ); _; }

        function registerVoter( address eoa ) public onlyChairman {
            voters[ eoa ].registered = true;
        }

        function vote( uint candNo ) public {
            require( voters[msg.sender].registered );
            require( !voters[msg.sender].voted );
            require( candNo < candidates.length );
            voters[msg.sender].votedFor = candNo;
            candidates[ candNo ].voteCount++;
        }

    function winnerView() public view returns (bytes32) {
        require(winnerName != "");
        return winnerName;
    }

    function winnerAnnounce() public {
        require(winnerName=="");
        uint maxVoteCount = 0;
        for( uint i=0; i < candidates.length; i++ ) {
            if( candidates[i].voteCount > maxVoteCount ) {
                maxVoteCount = candidates[i].voteCount;
                winnerName = candidates[i].name;
            }
        }
        emit winnerAnnounced( winnerName );
    }

    //Test case
    // Ac1 creates contract: candidates ["0x6666", "0x6767", "0x6868"]
    // Ac1 registers Ac2, Ac3, Ac4
    // Ac1 votes for cand 0
    // Ac2 votes for cand 1
    // Ac3 votes for cand 2
    // Ac4 votes for cand 2
    // Ac1 calls winnerAnnounce --> winnerName = "0x6868"

        constructor( bytes32[] candNames ) public {
                chairman = msg.sender;
                for( uint i = 0; i < candNames.length; i++) {
                        candidates.push(
                            Candidate(
                                { name: candNames[i],
                                  voteCount: 0 }
                             )
                         );
                }
                registerVoter( chairman );
        }

}
