pragma solidity ^0.4.24;

import './AuctionV2.sol';

contract BlindAuctionV1 is AuctionV2 {

    bool bidding = true;
    struct Bid {
        bytes32 bidHash;
        uint deposit;
    }

    mapping (address=>mapping (bytes32=>Bid)) bids;

    modifier ifBidding { require( bidding ); _; }

        function bid(bytes32 blindBid) public payable ifBidding {
            bids[msg.sender][blindBid] = Bid( {bidHash: blindBid, deposit: msg.value} );
        }

        function closeBidding() public onlySeller ifBidding {
            bidding=false;
        }

    function reveal(uint v, bool f, bytes32 s) public {
        require( !bidding );
        bytes32 bhash = keccak256(abi.encodePacked(v, f, s));

        Bid storage b = bids[msg.sender][bhash];

        uint refund=b.deposit;

        if( b.bidHash != bhash ) return;

        if( !f && b.deposit < v ) return;

        if( !f && b.deposit >= v && v > highestBid ) {
            if( highestBid != 0 ) moneyback[highestBidder] += highestBid;
            highestBid = v; highestBidder = msg.sender;
            return;
        }

        if( f || ( b.deposit >= v && v <= highestBid ) )
            b.deposit = 0;

        msg.sender.transfer(refund); // interact last
    }
}
